/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.block;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.adventurez.block.entity.PiglinFlagEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PiglinFlag
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape BASE = PiglinFlag.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
    private static final VoxelShape POLE = Shapes.m_83110_((VoxelShape)BASE, (VoxelShape)PiglinFlag.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)40.0, (double)9.0));
    private static final VoxelShape BAR_1 = Block.m_49796_((double)6.0, (double)40.0, (double)-8.0, (double)10.0, (double)44.0, (double)10.0);
    private static final VoxelShape BAR_2 = Block.m_49796_((double)6.0, (double)40.0, (double)6.0, (double)24.0, (double)44.0, (double)10.0);
    private static final VoxelShape BAR_3 = Block.m_49796_((double)6.0, (double)40.0, (double)6.0, (double)10.0, (double)44.0, (double)24.0);
    private static final VoxelShape BAR_4 = Block.m_49796_((double)-8.0, (double)40.0, (double)6.0, (double)10.0, (double)44.0, (double)10.0);
    private static final VoxelShape NORTH_FLAG = Shapes.m_83110_((VoxelShape)POLE, (VoxelShape)BAR_1);
    private static final VoxelShape EAST_FLAG = Shapes.m_83110_((VoxelShape)POLE, (VoxelShape)BAR_2);
    private static final VoxelShape SOUTH_FLAG = Shapes.m_83110_((VoxelShape)POLE, (VoxelShape)BAR_3);
    private static final VoxelShape WEST_FLAG = Shapes.m_83110_((VoxelShape)POLE, (VoxelShape)BAR_4);

    public PiglinFlag(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PiglinFlagEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return PiglinFlag.checkType(type, BlockInit.PIGLIN_FLAG_ENTITY, world.m_5776_() ? PiglinFlagEntity::clientTick : PiglinFlagEntity::serverTick);
    }

    @Environment(value=EnvType.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag options) {
        if (ConfigInit.CONFIG.allow_extra_tooltips) {
            tooltip.add((Component)Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
            if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                tooltip.remove(Component.m_237115_((String)"item.adventurez.moreinfo.tooltip"));
                tooltip.add((Component)Component.m_237115_((String)"block.adventurez.piglin_flag.tooltip"));
                tooltip.add((Component)Component.m_237115_((String)"block.adventurez.piglin_flag.tooltip2"));
                tooltip.add((Component)Component.m_237115_((String)"block.adventurez.piglin_flag.tooltip3"));
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122427_());
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.getShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return BASE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    private VoxelShape getShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (direction == Direction.NORTH) {
            return NORTH_FLAG;
        }
        if (direction == Direction.EAST) {
            return EAST_FLAG;
        }
        if (direction == Direction.SOUTH) {
            return SOUTH_FLAG;
        }
        if (direction == Direction.WEST) {
            return WEST_FLAG;
        }
        return NORTH_FLAG;
    }

    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

